unit TrdSynchronized;

interface
uses Classes, ThrdServer, IBAccess, SysUtils;

type

  TSyncRtnThread = class(TBaseServerThread)
  private
    FDb: TIBSqlQuery;
    FNxtAction: TSrverTaskObj;
    FSychReturn: TThreadMethod;
  protected
    procedure Execute; override;
  public  
    property NxtAction: TSrverTaskObj read FNxtAction;
    property SychReturn: TThreadMethod read FSychReturn write FSychReturn;
  end;


implementation



{ TSyncRtnThread }

procedure TSyncRtnThread.Execute;
var
  PrevAction: TSrverTaskObj;
begin
  //inherited;
  PrevAction := nil;
  if FDb = nil then
    FDb := TIBSqlQuery.Create;
  while not Terminated do
  try
    PrevAction := FNxtAction;
    FNxtAction := Pop;
    if FNxtAction <> nil then
    begin
      Sleep(500); //pretend a big search
      FDb.PopulateArray(FNxtAction.SqlCommand, FNxtAction.Results);
      if Assigned( FSychReturn) then
         Synchronize(FSychReturn);
      FreeAndNil(FNxtAction);
    end
    else
      if (PrevAction = nil) and not Terminated then
        Suspend;
  except
    Terminate;
  end;
end;

end.

